<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\common\model\AdminMenu as AdminMenuModel;
use app\common\service\Users as UsersService;

/**
 * @package app\admin\service
 * @class Purview
 * @author xzncit 2023-09-04
 */
class Purview {

    /**
     * 获取菜单
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getMenu(){
        $condition   = [];
        $condition[] = ["type","in","H,M"];
        $condition[] = ["status","=",1];
        if(!UsersService::isEmpty("purview") && UsersService::get("purview","") != "*"){
            $condition[] = ["id","in",UsersService::get("purview","")];
        }
        
        $array = AdminMenuModel::where($condition)->order("sort","ASC")->select()->toArray();
        $result = self::familyProcess($array);
        if(empty($result)){
            return [];
        }

        return array_values($result);
    }

    /**
     * @param $data
     * @param array $res
     * @param string $pid
     * @return array|mixed
     */
    public static function familyProcess($data,$res=[],$pid='0'){
        foreach($data as $item){
            if($item['pid'] == $pid){
                $res[$item['id']] = $item;
                $res[$item['id']]['children'] = array_values(self::familyProcess($data,[],$item['id']));
            }
        }

        return $res;
    }

    /**
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getAuth(){
        $array = [];
        $condition = [];
        $condition[] = ["type","in","M,B"];
        $condition[] = ["status","=",1];
        $condition[] = ["code","<>",""];
        if(!UsersService::isEmpty("purview") && UsersService::get("purview","") != "*"){
            $condition[] = ["id","in",UsersService::get("purview","")];
        }
        $menu  = AdminMenuModel::where($condition)->select()->toArray();
        foreach($menu as $key=>$value){
            $array[] = $value["code"];
        }

        return $array;
    }

    /**
     * 返回并组装路由
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getRoutes(){
        $condition   = [];
        $condition[] = ["component","<>",""];
        $condition[] = ["status","=",1];
        if(!UsersService::isEmpty("purview") && UsersService::get("purview","") != "*"){
            $condition[] = ["id","in",UsersService::get("purview","")];
        }
        $result      = AdminMenuModel::where($condition)->select()->toArray();
        $array       = [];
        foreach($result as $key=>$value){
            $array[] = [
                "path"      => $value["route"],
                "name"      => str_replace('/','',$value["route"]),
                "component" => $value["component"],
                "meta"=>[
                    "title"     => $value["name"],
                    "code"      => $value["code"],
                    "icon"      => $value["icon"],
                    "type"      => $value["type"],
                    "active"    => $value["selected"],
                    "hidden"    => $value["hidden"]
                ]
            ];
        }

        return $array;
    }

}