<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\common\model\goods\GoodsItem as GoodsItemModel;
use app\common\model\goods\Spec as SpecModel;
use app\common\model\goods\SpecValue as SpecValueModel;

/**
 * @package app\adminapi\service
 * @class Products
 * @author xzncit 2024-02-20
 */
class Products {

    /**
     * @param int $goods_id
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($goods_id=0){
        return GoodsItemModel::where("goods_id",$goods_id)->select()->map(function ($res){
            $array = explode(",",$res["spec_value"]);

            $spec = [];
            foreach($array as $k=>$item){
                $value     = explode(":",$item);
                $name      = SpecModel::where(["id"=>$value[0]])->value("name","");
                $specValue = SpecValueModel::where(["spec_id"=>$value[0],"id"=>$value[1]])->value("value","");
                $spec[]    = $name . ":" . $specValue;
            }

            $res["value"] = implode(",",$spec);
            $res["status"] = 1;
            return $res;
        });
    }

}