<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\common\exception\BaseException;
use app\common\model\AdminMenu as AdminMenuModel;
use app\common\library\utils\Data;

/**
 * @package app\admin\service
 * @class Menu
 * @author xzncit 2023-09-08
 */
class Menu {

    /**
     * 列表
     * @param array $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params=[]){
        $result = AdminMenuModel::where("pid",intval($params["id"]??0))->order('sort','ASC')->order("id","ASC")->select()->toArray();
        return array_map(function ($res){
            $res["hasChildren"] = AdminMenuModel::where("pid",$res["id"])->count() ? true : false;
            return $res;
        },$result);
    }

    /**
     * 修改状态
     * @param $params
     * @return AdminMenuModel
     * @throws BaseException
     */
    public static function status($params){
        if(!in_array($params["type"],["status"])){
            throw new BaseException("msg:error",0);
        }

        return AdminMenuModel::where("id",intval($params["id"]??0))->update([
            $params["type"]=>intval($params["value"]??0)
        ]);
    }

    public static function detail($id){
        $row = AdminMenuModel::where("id",$id)->find();
        $array = [];
        $array["cat_id"] = [];
        if(!empty($row)){
            $path = array_map(function ($num){ return (int)$num; },explode(",",$row["path"]));
            array_pop($path);
            $array["cat_id"]        = $path;
            $array["name"]          = $row["name"];
            $array["icon"]          = $row["icon"];
            $array["type"]          = $row["type"];
            $array["code"]          = $row["code"];
            $array["route"]         = $row["route"];
            $array["component"]     = $row["component"];
            $array["selected"]      = $row["selected"];
            $array["sort"]          = $row["sort"];
            $array["status"]        = $row["status"];
            $array["hidden"]        = $row["hidden"];
            $array["id"]            = $row["id"];
        }

        return $array;
    }

    public static function save($data){
        if(empty($data["cat_id"])){
            $data["cat_id"] = [];
        }

        $data["pid"]    = empty($data["cat_id"]) ? 0 : end($data["cat_id"]);
        if($data["pid"] <= 0){
            $data["level"] = 1;
        }else{
            $data["level"] = AdminMenuModel::where("id",$data["pid"])->value("level") + 1;
        }

        if(empty($data["id"])){
            $data["id"]             = (new AdminMenuModel())->withoutField("id")->insert($data,true);
            $data["cat_id"][]       = $data["id"];
            $data["path"]           = implode(",",$data["cat_id"]);
            AdminMenuModel::where("id",$data["id"])->save([ "path" => $data["path"] ]);
            return true;
        }

        $result = AdminMenuModel::where("id",$data["id"])->find();
        if(empty($result)){
            throw new BaseException("您要修改的内容不存在",0);
        }

        if(!Data::checkTree(AdminMenuModel::select()->toArray(),$data)){
            throw new BaseException("{$result['name']} 是 ID {$result['pid']} 的父栏目,不能修改！",0);
        }

        if($result["id"] == $data["pid"]){
            throw new BaseException("不允许选择上一级作为分类",0);
        }

        $data["cat_id"][]       = $data["id"];
        $data["path"]           = implode(",",$data["cat_id"]);
        AdminMenuModel::where("id",$data["id"])->save($data);
        return true;
    }

    /**
     * 排序
     * @param $params
     * @return AdminMenuModel
     */
    public static function sort($params){
        return AdminMenuModel::where("id",intval($params["id"]??0))->update([
            "sort"=>intval($params["sort"]??0)
        ]);
    }

    /**
     * 删除
     * @param $id
     * @return bool
     * @throws \think\db\exception\DbException
     */
    public static function delete($id){
        if(AdminMenuModel::where("pid",$id)->count() > 0){
            throw new \Exception("该分类下有子菜单，请先删除子菜单。",0);
        }

        return AdminMenuModel::where("id",$id)->delete();
    }

}