<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\common\exception\BaseException;
use app\common\model\AdminManage as AdminManageModel;
use app\common\model\AdminMenu as AdminMenuModel;

/**
 * @package app\adminapi\service
 * @class Manage
 * @author xzncit 2023-09-09
 */
class Manage {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $condition = [];
        $condition[] = ["title","like","%{$params['keywords']}%"];
        $count  = AdminManageModel::where($condition)->count();
        $result = AdminManageModel::where($condition)->order("id","ASC")->page($params["current"]??1,$params["size"]??10)->select()->toArray();

        $array["list"]  = $result;
        $array["total"] = $count;
        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $array       = [];
        $checked     = [];
        $row         = AdminManageModel::where("id",$id)->find();
        $system_menu = AdminMenuModel::where("pid",0)->order("sort","ASC")->select()->toArray();
        foreach($system_menu as $key=>$value){
            $checked[]   = $value["id"];
            $array[$key] = [
                "id"        => $value["id"],
                "label"     => $value["name"],
                "level"     => 1,
                "children"  => []
            ];

            $menu = AdminMenuModel::where("pid",$value["id"])->order("sort","ASC")->select()->toArray();
            foreach($menu as $k=>$v){
                $array[$key]["children"][$k] = [
                    "id"        => $v["id"],
                    "label"     => $v["name"],
                    "level"     => 2,
                    "children"  => []
                ];

                $child = AdminMenuModel::where("pid",$v["id"])->order("sort","ASC")->select()->toArray();
                foreach($child as $_k=>$_v){
                    $array[$key]["children"][$k]["children"][$_k] = [
                        "id"        => $_v["id"],
                        "label"     => $_v["name"],
                        "level"     => 3,
                        "children"  => []
                    ];

                    $children = AdminMenuModel::where("pid",$_v["id"])->order("sort","ASC")->select()->toArray();
                    foreach($children as $__k=>$__v){
                        $array[$key]["children"][$k]["children"][$_k]["children"][$__k] = [
                            "id"        => $__v["id"],
                            "label"     => $__v["name"],
                            "level"     => 4
                        ];
                    }
                }
            }
        }

        return [
            "tree"      => $array??[],
            "title"     => $row["title"]??"",
            "purview"   => (empty($row["purview"]) ? $checked : explode(",",$row["purview"])),
            "status"    => $row["status"]??1,
            "id"        => $row["id"]??0,
        ];
    }

    /**
     * 保存
     * @param $params
     * @return bool|int|string|\think\response\Json
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params){
        if(empty($params["title"])){
            return returnAjax("请填写名称",0);
        }else if(empty($params["purview"])){
            return returnAjax("请选择菜单",0);
        }

        $params["purview"] = implode(",",$params["purview"]??[]);
        if(empty($params["id"])){
            return (new AdminManageModel())->withoutField("id")->insert($params,true);
        }

        $row = AdminManageModel::where("id",$params["id"])->find();
        if(isset($row) && $row["lock"] == 1){
            throw new BaseException("该用户已锁定,不允许修改",0);
        }

        return AdminManageModel::where("id",$params["id"])->save($params);
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        $rows = AdminManageModel::where("id",$id)->find();
        if(empty($rows)){
            throw new BaseException("您查找的内容为空",0);
        }

        if($rows["lock"] == 1){
            throw new BaseException("该数据为空",0);
        }

        return AdminManageModel::where("id",$id)->delete();
    }

}