<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\common\library\utils\Image;
use app\common\model\ArchivesHelp as ArchivesHelpModel;
use app\common\service\Users as UsersService;

/**
 * @package app\adminapi\service
 * @class Help
 * @author xzncit 2024-03-05
 */
class Help {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $array["total"]  = ArchivesHelpModel::count();
        $array["list"]   = ArchivesHelpModel::order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();

        return $array;
    }

    public static function detail($id){
        $array = ArchivesHelpModel::where("id",$id)->find();
        if(empty($array)){
            return $array??[];
        }

        $array["content"] = Image::replace(Image::removeAttribute($array["content"]),function($path,$content){
            return str_replace($path, Image::thumb($path), $content);
        });

        return $array;
    }

    public static function save($params){
        $params["content"] = Image::replace($params["content"],function ($path,$content){
            return str_replace($path, Image::parseUrl($path), $content);
        });

        $params["author_id"] = UsersService::get("id");
        if(!empty($params["id"]) && ArchivesHelpModel::where("id",$params["id"])->find()){
            $params["update_time"] = time();
            ArchivesHelpModel::where("id",$params["id"])->save($params);
        }else{
            $params["create_time"] = time();
            $params["update_time"] = time();
            ArchivesHelpModel::create($params);
        }

        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        return ArchivesHelpModel::where("id",$id)->delete();
    }

}