<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\common\model\UsersGroup as UsersGroupModel;

/**
 * @package app\adminapi\service
 * @class Group
 * @author xzncit 2024-02-19
 */
class Group {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $condition = [];
        $condition[] = ["name","like","%{$params['keywords']}%"];
        $count  = UsersGroupModel::where($condition)->count();
        $result = UsersGroupModel::where($condition)->order("sort","ASC")->page($params["current"]??1,$params["size"]??10)->select()->toArray();

        return [
            "list"  => $result,
            "total" => $count
        ];
    }

    /**
     * 详情
     * @param $id
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $row = UsersGroupModel::where("id",$id)->find();
        if(empty($row)){
            return [];
        }

        return $row;
    }

    /**
     * 添加/修改
     * @param $params
     * @return UsersGroupModel|bool|\think\Model
     */
    public static function save($params){
        if(empty($params["id"])){
            $params["create_time"] = time();
            $params["update_time"] = time();
            return UsersGroupModel::create($params);
        }else{
            $params["update_time"] = time();
            return UsersGroupModel::where("id",$params["id"])->save($params);
        }
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        return UsersGroupModel::where("id",$id)->delete();
    }
}