<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\adminapi\model\Crontab as CrontabModel;
use app\common\model\CrontabLog as CrontabLogModel;
use Cron\CronExpression;

/**
 * @package app\adminapi\service
 * @class Crontab
 * @author xzncit 2024-02-29
 */
class Crontab {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = CrontabModel::withSearch(...$fields)->count();
        $result          = CrontabModel::withSearch(...$fields)->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();
        $array["list"]   = [];
        $time            = time();
        foreach($result as $key=>$value){
            $cron                = CronExpression::isValidExpression($value["schedule"]) ? CronExpression::factory($value["schedule"]) : "-";
            $value["next_time"]  = $time > $value['end_time'] ? "0" : $cron->getNextRunDate()->getTimestamp();
            $array["list"][$key] = $value;
        }

        return $array;
    }

    /**
     * 日志列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getLogList($params){
        $array           = [];
        $array["total"]  = CrontabLogModel::count();
        $array["list"]   = CrontabLogModel::order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->map(function ($res){
            $res["title"] = CrontabModel::where("id",$res["pid"])->value("title","");
            return $res;
        });
        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        return CrontabModel::where("id",$id)->find();
    }

    /**
     * 保存
     * @param array $params
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params=[]){
        if(!empty($params["id"]) && CrontabModel::where("id",$params["id"])->find()){
            $params["update_time"] = time();
            CrontabModel::where("id",$params["id"])->save($params);
        }else{
            $params["create_time"] = time();
            CrontabModel::create($params);
        }
    }

    /**
     * 删除
     * @param $id
     */
    public static function delete($id){
        CrontabModel::where("id",$id)->delete();
        CrontabLogModel::where("pid",$id)->delete();
    }

}