<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\common\model\Users as UsersModel;
use app\common\model\order\Order as OrderModel;
use app\common\library\utils\Date;

/**
 * @package app\adminapi\service
 * @class Chart
 * @author xzncit 2024-02-24
 */
class Chart {

    public static function getUsers(){
        $startTime = strtotime(date("Y-m-d 00:00:00",strtotime("-6 day")));
        $endTime = strtotime(date("Y-m-d 23:59:59"));

        $result = UsersModel::field('count(id) as yValue,create_time,FROM_UNIXTIME(create_time,"%m-%d") as xValue')
            ->where("create_time >= '{$startTime}' AND create_time <= '{$endTime}'")
            ->group("create_time having FROM_UNIXTIME(create_time,'%m-%d') >= FROM_UNIXTIME('{$startTime}','%m-%d') AND FROM_UNIXTIME(create_time,'%m-%d') <= FROM_UNIXTIME('{$endTime}','%m-%d')")
            ->order("create_time","ASC")->select()->toArray();

        $data = [];
        array_unshift($data,date("m-d"));
        for($i=1; $i<7;$i++){
            array_unshift($data,date("m-d",strtotime("-{$i} day")));
        }

        $data = array_map(function ($res){
            return 0;
        },array_flip($data));

        foreach ($result as $key => $val) {
            $data[$val['xValue']] = $val['yValue'];
        }

        return [ "x"=>array_keys($data), "y"=>array_values($data) ];
    }

    public static function getOrderAmount(){
        $startTime = strtotime(date("Y-m-d 00:00:00",strtotime("-6 day")));
        $endTime = strtotime(date("Y-m-d 23:59:59"));

        $result = OrderModel::field('SUM(order_amount) as yValue,create_time,FROM_UNIXTIME(create_time,"%m-%d") as xValue')
            ->where("status",6)
            ->where("create_time >= '{$startTime}' AND create_time <= '{$endTime}'")
            ->group("create_time having FROM_UNIXTIME(create_time,'%m-%d') >= FROM_UNIXTIME('{$startTime}','%m-%d') AND FROM_UNIXTIME(create_time,'%m-%d') <= FROM_UNIXTIME('{$endTime}','%m-%d')")
            ->order("create_time","ASC")->select()->toArray();

        $data = [];
        array_unshift($data,date("m-d"));
        for($i=1; $i<7;$i++){
            array_unshift($data,date("m-d",strtotime("-{$i} day")));
        }

        $data = array_map(function ($res){
            return 0;
        },array_flip($data));

        foreach ($result as $key => $val) {
            $data[$val['xValue']] = $val['yValue'];
        }

        return [ "x"=>array_keys($data), "y"=>array_values($data) ];
    }

    public static function getOrderCount(){
        $startTime = strtotime(date("Y-m-d 00:00:00",strtotime("-6 day")));
        $endTime = strtotime(date("Y-m-d 23:59:59"));

        $result = OrderModel::field('COUNT(id) as yValue,create_time,FROM_UNIXTIME(create_time,"%m-%d") as xValue')
            ->where("status",6)
            ->where("create_time >= '{$startTime}' AND create_time <= '{$endTime}'")
            ->group("create_time having FROM_UNIXTIME(create_time,'%m-%d') >= FROM_UNIXTIME('{$startTime}','%m-%d') AND FROM_UNIXTIME(create_time,'%m-%d') <= FROM_UNIXTIME('{$endTime}','%m-%d')")
            ->order("create_time","ASC")->select()->toArray();

        $data = [];
        array_unshift($data,date("m-d"));
        for($i=1; $i<7;$i++){
            array_unshift($data,date("m-d",strtotime("-{$i} day")));
        }

        $data = array_map(function ($res){
            return 0;
        },array_flip($data));

        foreach ($result as $key => $val) {
            $data[$val['xValue']] = $val['yValue'];
        }

        return [ "x"=>array_keys($data), "y"=>array_values($data) ];
    }

    public static function getOrderTotal($startTime,$endTime){
        $days = intval(Date::diff($startTime,$endTime));
        if($days <= 150){
            $formatDay = "%m-%d";
        }else{
            $formatDay = "%Y-%m";
        }

        $result = OrderModel::field("sum(order_amount) as yValue,create_time,FROM_UNIXTIME(create_time,'".$formatDay."') as xValue")
            ->where("status","in","2,3,4,5,6")
            ->where("create_time >= '{$startTime}' AND create_time <= '{$endTime}'")
            //->group("create_time having FROM_UNIXTIME(create_time,'".$formatDay."') >= FROM_UNIXTIME('{$startTime}','".$formatDay."') AND FROM_UNIXTIME(create_time,'".$formatDay."') <= FROM_UNIXTIME('{$endTime}','".$formatDay."')")
            ->order("create_time","ASC")
            ->select()->toArray();

        $data = [];
        array_unshift($data,date(str_replace("%","",$formatDay)));
        for($i=1; $i<7;$i++){
            array_unshift($data,date(str_replace("%","",$formatDay),strtotime("-{$i} " . ($days <= 150 ? 'day' : 'month'))));
        }

        $data = array_map(function ($res){
            return 0;
        },array_flip($data));

        foreach ($result as $key => $val) {
            $data[$val['xValue']] = $val['yValue'];
        }

        return [ "x"=>array_keys($data), "y"=>array_values($data) ];
    }

}