<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\common\exception\BaseException;
use app\common\model\Attachment as AttachmentModel;
use app\common\model\AttachmentCategory as AttachmentCategoryModel;
use app\common\library\utils\Image;
use app\common\library\file\FileManager;

/**
 * @package app\adminapi\service
 * @class Attachment
 * @author xzncit 2023-09-04
 */
class Attachment {

    /**
     * 获取图片列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array             = [];
        $condition         = [];

        if(!empty($params["keywords"])){
            $condition[] = ["filename","like",'%'.($params["keywords"]??'').'%'];
        }

        if(!empty($params["cat_id"])){
            $condition[] = ["cat_id","=",$params["cat_id"]??0];
        }

        if(!empty($params["accept"])){
            $params["accept"] = explode(",",str_replace(".","",$params["accept"]));
            $condition[] = ["image_type","in",$params["accept"]??""];
        }

        $array["category"] = AttachmentCategoryModel::order("id","ASC")->select()->toArray();
        $array["total"]    = AttachmentModel::where($condition)->count();
        $result            = AttachmentModel::where($condition)->order('id','desc')->page($params["current"]??1,$params["size"]??15)->select()->toArray();

        $array["list"]     = array_map(function ($res){
            return [
                "id"       => $res["id"],
                "title"    => $res["filename"],
                "active"   => 0,
                "photo"    => Image::thumb($res["path"]),
                "suffix"   => $res["image_type"]
            ];
        },$result);
        return $array;
    }

    /**
     * 获取分组列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getGroupList(){
        return AttachmentCategoryModel::field("id,name")->select()->toArray();
    }

    /**
     * 添加/修改分组
     * @param array $params
     * @return bool
     * @throws BaseException
     * @throws \think\db\exception\DbException
     */
    public static function createGroup($params=[]){
        if(empty($params["name"])){
            throw new BaseException("请输入名称",0);
        }

        $condition = ["id"=>$params["id"]??0];
        if(AttachmentCategoryModel::where($condition)->count()){
            AttachmentCategoryModel::where($condition)->save(["name"=>$params["name"]]);
        }else{
            AttachmentCategoryModel::create(["name"=>$params["name"]]);
        }

        return true;
    }

    /**
     * 删除分组并且将分类下附件一并删除
     * @param $id
     * @return bool
     * @throws BaseException
     */
    public static function deleteGroup($id){
        if(!AttachmentCategoryModel::where("id",$id)->delete()){
            return false;
        }

        AttachmentModel::where("cat_id",$id)->chunk(100,function ($attachment){
            foreach($attachment as $value){
                FileManager::delete($value);
            }
        });

        return true;
    }

    /**
     * 删除附件
     * @param $id
     * @return bool
     * @throws BaseException
     */
    public static function delete($id){
        $array = array_map("intval",explode(",",$id));
        if(count($array) <= 0){
            throw new BaseException("请选择需要删除的图片",0);
        }

        AttachmentModel::where("id","in",$array)->chunk(100,function ($attachment){
            foreach($attachment as $value){
                FileManager::delete($value);
            }
        });

        return true;
    }

}