<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\common\exception\BaseException;
use app\common\library\utils\Image;
use app\adminapi\model\Archives as ArchivesModel;
use app\common\service\Category as CategoryService;
use app\common\service\Users as UsersService;

/**
 * @package app\admin\service
 * @class Archives
 * @author xzncit 2023-09-04
 */
class Archives {

    public static function getDiyList($params=[]){
        $result = ArchivesModel::where("pid",$params["id"]??0)->limit($params["limit"]??20)->select()->toArray();
        $array = [];
        foreach($result as $value){
            $array[] = [
                "name"          => $value["title"],
                "image"         => Image::thumb($value["photo"],["domain"=>true])
            ];
        }

        return $array;
    }

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = ArchivesModel::withSearch(...$fields)->withJoin("category")->count();
        $result          = ArchivesModel::withSearch(...$fields)->withJoin("category")->order("archives.id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();
        $array["list"]   = [];
        foreach($result as $key=>$value){
            $array["list"][$key]            = $value;
            $array["list"][$key]["photo"]   = Image::thumb($value["photo"]);
        }

        return $array;
    }

    public static function detail($id){
        $array = ArchivesModel::where("id",$id)->find();
        if(empty($array)){
            return $array??[];
        }

        $array["pid"]     = array_map(function ($num){
            return (int)$num;
        },array_reverse(CategoryService::parent($array["pid"])));
        $array["photo"]   = !empty($array["photo"]) ? Image::thumb($array["photo"]) : "";
        $array["content"] = Image::replace(Image::removeAttribute($array["content"]),function($path,$content){
            return str_replace($path, Image::thumb($path), $content);
        });

        return $array;
    }

    public static function save($params){
        $params["pid"]     = empty($params["pid"]) ? 0 : end($params["pid"]);
        $params["photo"]   = Image::parseUrl($params["photo"]??"");
        $params["content"] = Image::replace($params["content"],function ($path,$content){
            return str_replace($path, Image::parseUrl($path), $content);
        });

        $params["author_id"] = UsersService::get("id");
        if(!empty($params["id"]) && ArchivesModel::where("id",$params["id"])->find()){
            $params["update_time"] = time();
            ArchivesModel::where("id",$params["id"])->save($params);
        }else{
            $params["create_time"] = time();
            $params["update_time"] = time();
            ArchivesModel::create($params);
        }

        return true;
    }

    /**
     * 修改状态
     * @param $params
     * @return bool
     * @throws BaseException
     */
    public static function status($params){
        if(!in_array($params["type"],["status"])){
            throw new BaseException("error status",0);
        }

        $data = [ $params["type"]=>intval($params["value"]??0) ];
        ArchivesModel::where("id",$params["id"]??0)->save($data);
        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        return ArchivesModel::where("id",$id)->delete();
    }

}