<?php

namespace app\adminapi\model\users;

use app\common\model\Users as UsersModel;
use app\common\model\Payment as PaymentModel;
use app\common\model\users\UsersWithdraw as UsersWithdrawModel;

/**
 * @package app\adminapi\model\users
 * @class UsersWithdraw
 * @author xzncit 2024/4/14
 */
class UsersWithdraw extends UsersWithdrawModel {

    /**
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchActiveAttr($query, $value, $data){
        if(!empty($value) && is_numeric($value)){
            $query->where("users_withdraw.status","=",$value);
        }
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function users(){
        return $this->hasOne(UsersModel::class,'id','user_id')->joinType("LEFT");
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function payment(){
        return $this->hasOne(PaymentModel::class,'id','pay_id')->joinType("LEFT");
    }

}