<?php

namespace app\adminapi\model\users;

use app\common\model\UsersComment as UsersCommentModel;
use app\common\model\goods\Goods as GoodsModel;

/**
 * @package app\adminapi\model\users
 * @class UsersComment
 * @author xzncit 2024/3/21
 */
class UsersComment extends UsersCommentModel {

    /**
     * 增加查询条件
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchTitleAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("goods.title","like","%".$value."%");
        }
    }

    public function goods(){
        return $this->hasOne(GoodsModel::class,'id','goods_id');
    }

}