<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\model\shop;

use app\common\model\goods\Goods as GoodsModel;

/**
 * @package app\adminapi\model\shop
 * @class Goods
 * @author xzncit 2024-02-15
 */
class Goods extends GoodsModel {

    /**
     * 增加查询条件
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchTitleAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("title","like","%".$value."%");
        }
    }

    /**
     * 增加查询条件
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchActiveAttr($query, $value, $data){
        if(isset($value) && in_array($value,[0,1])){
            $query->where("status","=",$value);
        }
    }

}