<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\model\promotion;

use app\common\model\promotion\Bargain as BargainModel;
use app\common\model\promotion\BargainUsers as BargainUsersModel;
use app\common\model\goods\Goods as GoodsModel;

/**
 * @package app\adminapi\model\promotion
 * @class BargainUsers
 * @author xzncit 2024-02-22
 */
class BargainUsers extends BargainUsersModel {

    /**
     * 增加查询条件
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchActiveAttr($query, $value, $data){
        if(isset($value) && in_array($value,[0,1,2])){
            switch($value){
                case 0:
                    $query->where("bargain_users.status","=",1);
                    break;
                case 1:
                    $query->where("bargain_users.status","=",2);
                    break;
                case 2:
                    $query->where("bargain_users.status","=",3);
                    break;
            }
        }
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function bargain(){
        return $this->hasOne(BargainModel::class,'id','bargain_id')->joinType("LEFT");
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function goods(){
        return $this->hasOne(GoodsModel::class,'id','goods_id')->joinType("LEFT")->bind([
            "photo"
        ]);
    }

}