<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\model\order;

use app\common\model\order\Order as OrderModel;
use app\common\model\order\OrderRefunds as OrderRefundsModel;

/**
 * @package app\adminapi\model\order
 * @class OrderRefunds
 * @author xzncit 2024-02-27
 */
class OrderRefunds extends OrderRefundsModel {

    public function searchTypeAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("order_refunds.type","=",$value);
        }
    }

    public function searchStatusAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("order_refunds.status","=",$value);
        }
    }

    public function searchOrderNoAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("orders.order_no","like","%{$value}%");
        }
    }

    public function searchTimeAttr($query, $value, $data){
        if(!empty($value)){
            $query->whereBetweenTime("orders.create_time",$value[0],$value[1]);
        }
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function orders(){
        return $this->hasOne(OrderModel::class,'id','order_id');
    }

}