<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\model\order;

use app\common\model\order\Order as OrderModel;
use app\common\model\order\OrderInvoice as OrderInvoiceModel;

/**
 * @package app\adminapi\model\order
 * @class OrderInvoice
 * @author xzncit 2024-02-27
 */
class OrderInvoice extends OrderInvoiceModel {

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function orders(){
        return $this->hasOne(OrderModel::class,'id','order_id')->joinType("LEFT")->bind([
            "order_no","payable_amount","order_amount"
        ]);
    }

}