<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\model\order;

use app\common\model\order\Order as OrderModel;
use app\common\model\order\OrderAddress as OrderAddressModel;
use app\common\model\Payment as PaymentModel;
use app\common\model\goods\Distribution as DistributionModel;
use app\common\model\goods\Freight as FreightModel;

/**
 * @package app\adminapi\model\order
 * @class Order
 * @author xzncit 2024-02-25
 */
class Order extends OrderModel {

    /**
     * 增加查询条件
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchActiveAttr($query, $value, $data){
        if(!empty($value)){
            switch($value){
                case 1:
                    $query->where("order.status","in","1,2");
                    break;
                case 2:
                    $query->where("order.status","=","3");
                    break;
                case 3:
                    $query->where("order.status","in","4,5");
                    break;
                case 4:
                    $query->where("order.refund_status","in","2,3");
                    break;
                case 5:
                    $query->where("order.status","=","6");
                    $query->where("order.evaluate_status","=",1);
                    break;
            }
        }
    }

    public function searchOrderNoAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("order.order_no","like","%{$value}%");
        }
    }

    public function searchAcceptNameAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("address.accept_name","like","%{$value}%");
        }
    }

    public function searchTypeAttr($query, $value, $data){
        if(isset($value) && $value != '-1'){
            $query->where("order.type","=",$value);
        }
    }

    public function searchPayStatusAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("order.pay_status","=",$value);
        }
    }

    public function searchDeliveryStatusAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("order.delivery_status","=",$value);
        }
    }

    public function searchTimeAttr($query, $value, $data){
        if(!empty($value)){
            $query->whereBetweenTime("order.create_time",$value[0],$value[1]);
        }
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function payment(){
        return $this->hasOne(PaymentModel::class,'id','pay_id')->joinType("LEFT")->bind(["pay_name"=>"name"]);
    }

    public function delivery(){
        return $this->hasOne(DistributionModel::class,'id','delivery_id')->joinType("LEFT")->bind(["delivery_name"=>"title"]);
    }

    public function freight(){
        return $this->hasOne(FreightModel::class,'id','express_id')->joinType("LEFT")->bind(["freight_name"=>"title"]);
    }

    public function address(){
        return $this->hasOne(OrderAddressModel::class,'order_id','id')->joinType("LEFT")->bind(["accept_name","mobile","province","city","area","address"]);
    }

}