<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\model;

use think\Model;
use app\common\model\UsersGroup;

class Users extends Model {

    /**
     * 增加查询条件
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchUsernameAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("users.username|users.nickname|users.email|users.mobile","like","%".$value."%");
        }
    }

    /**
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchActiveAttr($query, $value, $data){
        if(!empty($value) && is_numeric($value)){
            $query->where("users.status","=",$value);
        }
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function group(){
        return $this->hasOne(UsersGroup::class,'id','group_id')->joinType("LEFT")->bind(["group_name"=>"name"]);
    }

}