<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\model;

use app\common\model\Category;
use app\common\model\Archives as ArchivesModel;

/**
 * @package app\adminapi\model
 * @class Archives
 * @author xzncit 2023-09-04
 */
class Archives extends ArchivesModel {

    /**
     * 增加查询条件
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchTitleAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("archives.title","like","%".$value."%");
        }
    }

    public function searchActiveAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("archives.status","like","%".$value."%");
        }
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function category(){
        return $this->hasOne(Category::class,'id','pid')->joinType("LEFT")->bind(["cat_name"=>"title"]);
    }

}