<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\model;

use app\common\model\Admin as AdminModel;
use app\common\model\AdminManage;

class Admin extends AdminModel {

    /**
     * 增加查询条件
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchTitleAttr($query, $value, $data){
        if(!empty($value)){
            $query->where("admin.username|admin.email","like","%".$value."%");
        }
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function manage(){
        return $this->hasOne(AdminManage::class,'id','role_id')->joinType("LEFT")->bind(["cat_name"=>"title"]);
    }

}