<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\users;

use app\adminapi\controller\Controller;
use app\adminapi\service\Users as UsersService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\users
 * @class Users
 * @author xzncit 2024-01-12
 */
class Users extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,UsersService::getList(Request::param()));
    }

    /**
     * 详情
     * @return \think\response\Json
     */
    public function detail(){
        return returnAjax("msg:ok",1,UsersService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        return returnAjax("msg:ok",1,UsersService::save(Request::param()));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,UsersService::delete(Request::param("id",0,"intval")));
    }

    /**
     * 设置
     * @return \think\response\Json
     */
    public function setting(){
        return returnAjax("msg:ok",1,UsersService::setting(Request::param()));
    }

}