<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\users;

use app\adminapi\controller\Controller;
use app\adminapi\service\Group as GroupService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\users
 * @class Group
 * @author xzncit 2024-01-12
 */
class Group extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,GroupService::getList(Request::param()));
    }

    /**
     * 详情
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail(){
        return returnAjax("msg:ok",1,GroupService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        return returnAjax("msg:ok",1,GroupService::save(Request::param()));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,GroupService::delete(Request::param("id",0,"intval")));
    }

}