<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\system;

use app\adminapi\controller\Controller;
use app\adminapi\service\Admin as AdminService;
use app\adminapi\service\System as SystemService;
use app\common\service\Users as UsersService;
use think\facade\Request;

/**
 * @package app\admin\controller\system
 * @class Users
 * @author xzncit 2023-09-09
 */
class Users extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,AdminService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,AdminService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,AdminService::detail(Request::param("id",0,"intval")));
    }

    public function password(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,AdminService::password(Request::param()));
        }

        return returnAjax("msg:ok",1,UsersService::get("nickname"));
    }

    /**
     * 店铺设置
     * @return \think\response\Json
     * @throws \think\db\exception\DbException
     */
    public function setting(){
        return returnAjax("msg:ok",1,SystemService::shopSetting(Request::param()));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,AdminService::delete(Request::param("id",0,"intval")));
    }

}