<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\system;

use app\adminapi\controller\Controller;
use app\adminapi\service\System as SystemService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\system
 * @class System
 * @author xzncit 2024-01-12
 */
class System extends Controller {

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DbException
     */
    public function email(){
        return returnAjax("msg:ok",1,SystemService::email(Request::param()));
    }

    /**
     * @return \think\response\Json
     */
    public function copy(){
        return returnAjax("msg:ok",1,SystemService::copy(Request::param()));
    }

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DbException
     */
    public function service(){
        return returnAjax("msg:ok",1,SystemService::saveAgree(Request::param(),"service"));
    }

    /**
     * @return \think\response\Json
     * @throws \think\db\exception\DbException
     */
    public function privacy(){
        return returnAjax("msg:ok",1,SystemService::saveAgree(Request::param(),"privacy"));
    }

    public function keywords(){
        return returnAjax("msg:ok",1,SystemService::savekeywords(Request::param(),"privacy"));
    }

}