<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\system;

use app\adminapi\controller\Controller;
use app\adminapi\service\Manage as ManageService;
use think\facade\Request;

/**
 * @package app\admin\controller\system
 * @class Purview
 * @author xzncit 2023-09-09
 */
class Purview extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,ManageService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,ManageService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,ManageService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,ManageService::delete(Request::param("id",0,"intval")));
    }

}