<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\system;

use app\adminapi\controller\Controller;
use app\adminapi\service\Menu as MenuService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\system
 * @class Menu
 * @author xzncit 2023-09-08
 */
class Menu extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,MenuService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,MenuService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,MenuService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 状态
     * @return \think\response\Json
     */
    public function status(){
        return returnAjax("msg:ok",1,MenuService::status(Request::param()));
    }

    /**
     * 排序
     * @return \think\response\Json
     */
    public function sort(){
        return returnAjax("msg:ok",1,MenuService::sort(Request::param()));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,MenuService::delete(Request::param("id",0,"intval")));
    }
}