<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\shop;

use think\facade\Request;
use app\adminapi\controller\Controller;
use app\adminapi\service\shop\Region as RegionService;

/**
 * @package app\adminapi\controller\shop
 * @class Region
 * @author xzncit 2024-02-14
 */
class Region extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,RegionService::getList(Request::param("id",0,"intval")));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,RegionService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,RegionService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,RegionService::delete(Request::param("id",0,"intval")));
    }

}