<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\shop;

use think\facade\Request;
use app\adminapi\controller\Controller;
use app\adminapi\service\shop\Goods as GoodsService;
use app\common\service\Config as ConfigService;

/**
 * @package app\adminapi\controller\shop
 * @class Goods
 * @author xzncit 2024-02-15
 */
class Goods extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,GoodsService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,GoodsService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,GoodsService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 上架
     * @return \think\response\Json
     */
    public function market(){
        return returnAjax("msg:ok",1,GoodsService::status(Request::param("id",0),0));
    }

    /**
     * 下架
     * @return \think\response\Json
     */
    public function store(){
        return returnAjax("msg:ok",1,GoodsService::status(Request::param("id",0),1));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,GoodsService::delete(Request::param("id",0)));
    }

    /**
     * 商品设置
     * @return \think\response\Json
     * @throws \think\db\exception\DbException
     */
    public function setting(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,GoodsService::setting(Request::param()));
        }

        return returnAjax("msg:ok",1,ConfigService::getArray("goods","件"));
    }

}