<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\shop;

use think\facade\Request;
use app\adminapi\controller\Controller;
use app\adminapi\service\shop\Distribution as DistributionService;
use app\adminapi\validate\DistributionValidate;

class Distribution extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,DistributionService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            $params = Request::param();
            validate(DistributionValidate::class)->check($params);
            return returnAjax("msg:ok",1,DistributionService::save($params));
        }

        return returnAjax("msg:ok",1,DistributionService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 状态
     * @return \think\response\Json
     */
    public function status(){
        return returnAjax("msg:ok",1,DistributionService::status(Request::param()));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,DistributionService::delete(Request::param("id",0,"intval")));
    }

}