<?php

namespace app\adminapi\controller\shop;

use app\adminapi\controller\Controller;
use app\adminapi\service\shop\Comments as CommentsService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\shop
 * @class Comment
 * @author xzncit 2024/3/21
 */
class Comments extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,CommentsService::getList(Request::param()));
    }

    /**
     * 详情|保存
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function detail(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,CommentsService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,CommentsService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 删除
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function delete(){
        return returnAjax("msg:ok",1,CommentsService::delete(Request::param("id",0,"intval")));
    }

}