<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\shop;

use app\adminapi\controller\Controller;
use app\adminapi\service\shop\Brand as BrandService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\shop
 * @class Brand
 * @author xzncit 2024-02-14
 */
class Brand extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,BrandService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,BrandService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,BrandService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 状态
     * @return \think\response\Json
     */
    public function status(){
        return returnAjax("msg:ok",1,BrandService::status(Request::param()));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,BrandService::delete(Request::param("id",0,"intval")));
    }

}