<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\promotion;

use app\adminapi\controller\Controller;
use app\adminapi\service\promotion\Recharge as RechargeService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\promotion
 * @class Recharge
 * @author xzncit 2024-02-21
 */
class Recharge extends Controller {

    /**
     * 充值订单
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function order(){
        return returnAjax("msg:ok",1,RechargeService::getOrderList(Request::param()));
    }

    /**
     * 充值设置
     * @return \think\response\Json
     * @throws \think\db\exception\DbException
     */
    public function setting(){
        return returnAjax("msg:ok",1,RechargeService::setting(Request::param()));
    }

}