<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\promotion;

use app\adminapi\controller\Controller;
use app\adminapi\service\promotion\Rebate as RebateService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\promotion
 * @class Rebate
 * @author xzncit 2024-02-19
 */
class Rebate extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,RebateService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,RebateService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,RebateService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 状态
     * @return \think\response\Json
     */
    public function status(){
        return returnAjax("msg:ok",1,RebateService::status(Request::param()));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,RebateService::delete(Request::param("id",0,"intval")));
    }

}