<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\promotion;

use app\adminapi\controller\Controller;
use app\adminapi\service\shop\Brand as BrandService;
use app\adminapi\service\promotion\Coupon as CouponService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\promotion
 * @class Coupon
 * @author xzncit 2024-02-18
 */
class Coupon extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,CouponService::getList(Request::param()));
    }

    public function receive(){
        return returnAjax("msg:ok",1,CouponService::getReceive(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,CouponService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,CouponService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 状态
     * @return \think\response\Json
     */
    public function status(){
        return returnAjax("msg:ok",1,CouponService::status(Request::param()));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,CouponService::delete(Request::param("id",0,"intval")));
    }

}