<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\order;

use app\adminapi\controller\Controller;
use app\common\library\file\FileManager;
use app\adminapi\service\order\Shipping as ShippingService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\order
 * @class Shipping
 * @author xzncit 2024-02-28
 */
class Shipping extends Controller {

    public $auth = ['except'=>['upload','import']];

    /**
     * 列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,ShippingService::getList());
    }

    /**
     * 详情
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail(){
        return returnAjax("msg:ok",1,ShippingService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 下载错误信息
     * @return \think\response\Json
     */
    public function download(){
        return returnAjax("msg:ok",1,ShippingService::download(Request::param("id",0,"intval")));
    }

    /**
     * 删除
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function delete(){
        return returnAjax("msg:ok",1,ShippingService::delete(Request::param("id",0,"intval")));
    }

    /**
     * 导入
     * @return \think\response\Json
     * @throws \Exception
     */
    public function import(){
        return returnAjax("msg:ok",1,ShippingService::import(Request::param()));
    }

    /**
     * @return \think\response\Json
     */
    public function upload(){
        try{
            $id = Request::param("id",0,"intval");
            $array = FileManager::upload("file",0,false,[
                "ext"       => ["csv","xls","xlsx"],
                "save"      => false
            ]);

            $id = ShippingService::save(["id"=>$id,"load_path"=>trim($array["path"],"/")]);

            return returnAjax("msg:ok",1,[
                "id"=>$id,
                "path"=>$array["path"]
            ]);
        }catch (\Exception $ex){
            return returnAjax($ex->getMessage(),0);
        }
    }

}