<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\order;

use app\adminapi\controller\Controller;
use app\adminapi\service\order\Refund as RefundService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\order
 * @class Refund
 * @author xzncit 2024-02-27
 */
class Refund extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,RefundService::getList(Request::param()));
    }

    /**
     * 详情
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail(){
        return returnAjax("msg:ok",1,RefundService::detail(Request::param("id",0,"intval")));
    }

    public function save(){
        return returnAjax("msg:ok",1,RefundService::save(Request::param()));
    }

}