<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\order;

use think\facade\Request;
use app\adminapi\controller\Controller;
use app\adminapi\service\order\Order as OrderService;

/**
 * @package app\adminapi\controller\order
 * @class Index
 * @author xzncit 2024-02-25
 */
class Index extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,OrderService::getList(Request::param()));
    }

    /**
     * 详情
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail(){
        return returnAjax("msg:ok",1,OrderService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 修改订单价格
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function update(){
        return returnAjax("msg:ok",1,OrderService::updatePrice(Request::param()));
    }

    /**
     * 取消订单
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function cancel(){
        return returnAjax("msg:ok",1,OrderService::cancel(Request::param("id",0,"intval")));
    }

    /**
     * 查询物流
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function express(){
        return returnAjax("msg:ok",1,OrderService::express(Request::param("id",0,"intval")));
    }

    /**
     * 发货
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function delivery(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,OrderService::sendDelivery(Request::param()));
        }

        return returnAjax("msg:ok",1,OrderService::getFreight(Request::param("id",0,"intval")));
    }

    public function refund(){

    }

    /**
     * 导出
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function export(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,OrderService::export(Request::param()));
        }

        return returnAjax("msg:ok",1,OrderService::getExportList(Request::param()));
    }

    /**
     * 删除导出内容
     * @return \think\response\Json
     */
    public function delete_export(){
        return returnAjax("msg:ok",1,OrderService::deleteExport(Request::param("id",0,"intval")));
    }

    /**
     * 订单设置
     * @return \think\response\Json
     * @throws \think\db\exception\DbException
     */
    public function setting(){
        return returnAjax("msg:ok",1,OrderService::setting(Request::param()));
    }

    /**
     * 批量打印小票
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function ticket(){
        return returnAjax("msg:ok",1,OrderService::ticket(Request::param("id",0,"intval")));
    }

}