<?php

namespace app\adminapi\controller\finance;

use app\adminapi\controller\Controller;
use app\adminapi\service\finance\Finance as FinanceService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\finance
 * @class Index
 * @author xzncit 2024/4/13
 */
class Index extends Controller {

    public function index(){
        return returnAjax("msg:ok",1,FinanceService::getList(Request::param()));
    }

    public function editor(){
        if(Request::isGet()){
            return returnAjax("msg:ok",1,FinanceService::detail(Request::param("id")));
        }

        return returnAjax("msg:ok",1,FinanceService::save(Request::param()));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,FinanceService::delete(Request::param("id",0,"intval")));
    }

    /**
     * 汇款设置
     * @return \think\response\Json
     * @throws \think\db\exception\DbException
     */
    public function setting(){
        return returnAjax("msg:ok",1,FinanceService::setting(Request::param()));
    }

}