<?php

namespace app\adminapi\controller\diy;

use think\facade\Request;
use app\adminapi\controller\Controller;
use app\adminapi\service\diy\Topic as TopicService;

/**
 * @package app\adminapi\controller\diy
 * @class Topic
 * @author xzncit 2024/3/29
 */
class Topic extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,TopicService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,TopicService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,TopicService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,TopicService::delete(Request::param("id",0,"intval")));
    }

}