<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\diy;

use app\adminapi\controller\Controller;
use app\common\library\utils\Image;
use app\common\service\diy\Setting as SettingService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\diy
 * @class Setting
 * @author xzncit 2023-12-25
 */
class Setting extends Controller {

    /**
     * @return \think\response\Json
     */
    public function index(){
        if(Request::isPost()){
            $params = Request::param();
            if(!empty($params["image"])){
                $params["image"] = Image::parseUrl($params["image"]);
            }

            return returnAjax("保存成功",1,SettingService::save($params,["name"=>"site"]));
        }

        $site = SettingService::get(["name"=>"site"]);
        if(!empty($site["image"])){
            $site["image"]  = Image::thumb($site["image"]??"",["domain"=>true]);
        }

        return returnAjax("msg:ok",1,$site);
    }

}