<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\diy;

use app\adminapi\controller\Controller;
use app\common\library\utils\Image;
use think\facade\Config;
use think\facade\Request;
use app\adminapi\service\diy\Layout as LayoutService;
use app\common\service\diy\Setting as SettingService;

/**
 * @package app\admin\controller\diy
 * @class Index
 * @author xzncit 2023-11-26
 */
class Index extends Controller {

    /**
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,LayoutService::getLayout(Request::param()));
    }

    /**
     * @return \think\response\Json
     */
    public function save(){
        LayoutService::saveLayout(Request::param());
        return returnAjax("保存成功",1);
    }

    /**
     * @return \think\response\Json
     */
    public function title(){
        $params = Request::param();
        if(empty($params["value"])){
            return returnAjax("请输入名称",0);
        }

        $condition = [];
        if(is_numeric($params["id"])){
            $condition[] = ["id","=",intval($params["id"]??0)];
            $condition[] = ["page_type","=","2"];
        }else{
            $condition[] = ["type","=",trim($params["id"])];
            $condition[] = ["page_type","=","1"];
        }

        LayoutService::setData(["name"=>$params["value"]],$condition);
        return returnAjax("保存成功",1);
    }

    /**
     * @return \think\response\Json
     */
    public function page(){
        return returnAjax("msg:ok",1,LayoutService::getData(["type"=>Request::param("type","","trim,strip_tags")]));
    }

    /**
     * @return \think\response\Json
     */
    public function tabbar(){
        if(Request::isPost()){
            $tabbar = Request::param();
            foreach($tabbar["list"] as $key=>$value){
                $tabbar["list"][$key]["image"]         = Image::parseUrl($value["image"]);
                $tabbar["list"][$key]["selectedImage"] = Image::parseUrl($value["selectedImage"]);
            }

            return returnAjax("保存成功",1,SettingService::save($tabbar,["name"=>"tabbar"]));
        }

        $tabbar = SettingService::get(["name"=>"tabbar"]);
        foreach($tabbar["list"] as $key=>$value){
            $tabbar["list"][$key]["image"]         = Image::thumb($value["image"]);
            $tabbar["list"][$key]["selectedImage"] = Image::thumb($value["selectedImage"]);
        }

        return returnAjax("msg:ok",1,$tabbar);
    }

    /**
     * @return \think\response\Json
     */
    public function color(){
        if(Request::isPost()){
            $params = Request::param();
            $tabbar = SettingService::get(["name"=>"tabbar"]);
            $tabbar["selectedColor"] = $params["options"]["backgroundColor"];

            $list = [];
            $list[] = ["image"=> "/static/mobile/tabbar/white/1.png", "selectedImage"=>"", "text"=> "首页", "status"=> 1, "link"=> "pages/index/index"];
            $list[] = ["image"=> "/static/mobile/tabbar/white/2.png", "selectedImage"=>"", "text"=> "分类", "status"=> 1, "link"=> "pages/index/category"];
            $list[] = ["image"=> "/static/mobile/tabbar/white/3.png", "selectedImage"=>"", "text"=> "消息", "status"=> 1, "link"=> "pages/service/index"];
            $list[] = ["image"=> "/static/mobile/tabbar/white/4.png", "selectedImage"=>"", "text"=> "购物车", "status"=> 1, "link"=> "pages/index/cart"];
            $list[] = ["image"=> "/static/mobile/tabbar/white/5.png", "selectedImage"=>"", "text"=> "我的", "status"=> 1, "link"=> "pages/index/ucenter"];
            $tabbar["list"] = $list;
            $index = 1;
            foreach($list as $key=>$value){
                $tabbar["list"][$key]["selectedImage"] = '/static/mobile/tabbar/' . $params["id"] . '/' . ($index) . '.png';
                $index++;
            }

            SettingService::save($tabbar,["name"=>"tabbar"]);
            SettingService::save($params,["name"=>"color"]);
            return returnAjax("保存成功",1);
        }

        return returnAjax("msg:ok",1,[
            "theme"     => Config::get("theme"),
            "setting"   => SettingService::get(["name"=>"color"],Config::get("theme")[0])
        ]);
    }

}