<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\diy;

use app\adminapi\controller\Controller;
use app\adminapi\service\Archives as ArchivesService;
use app\adminapi\service\shop\Goods as GoodsService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\diy
 * @class Common
 * @author xzncit 2023-11-26
 */
class Common extends Controller {

    public $auth = ['except'=>['category','shop_category']];

    /**
     * @return \think\response\Json
     */
    public function category(){
        return returnAjax("msg:ok",1,ArchivesService::getDiyList(Request::param()));
    }

    /**
     * @return \think\response\Json
     */
    public function shop_category(){
        return returnAjax("msg:ok",1,GoodsService::getDiyList(Request::param()));
    }

}