<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\addons;

use app\adminapi\controller\Controller;
use app\adminapi\service\Message as MessageService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\addons
 * @class Sms
 * @author xzncit 2024-02-23
 */
class Sms extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,MessageService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isGet()){
            return returnAjax("msg:ok",1,MessageService::detail(Request::param("id",0,"intval")));
        }

        return returnAjax("msg:ok",1,MessageService::save(Request::param()));
    }

    /**
     * 设置
     * @return \think\response\Json
     */
    public function setting(){
        return returnAjax("msg:ok",1,MessageService::setting(Request::param()));
    }

}