<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\addons;

use app\adminapi\controller\Controller;
use app\adminapi\service\wechat\Reply as ReplyService;
use think\facade\Request;

/**
 * @package app\adminapi\controller\addons
 * @class Reply
 * @author xzncit 2024-02-22
 */
class Reply extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,ReplyService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function editor(){
        if(Request::isPost()){
            ReplyService::save(Request::param());
            return returnAjax("保存成功",1);
        }

        return returnAjax("msg:ok",1,ReplyService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,ReplyService::delete(Request::param("id")));
    }

}