<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\addons;

use app\adminapi\controller\Controller;
use app\adminapi\service\Payment as PaymentService;
use app\common\library\utils\Image;
use app\common\model\Payment as PaymentModel;
use app\common\library\file\File;
use app\common\library\file\FileManager;
use app\common\service\Config;
use think\facade\Request;

/**
 * @package app\adminapi\controller\addons
 * @class Payment
 * @author xzncit 2024-02-23
 */
class Payment extends Controller {

    public $auth = ['except'=>['upload']];

    /**
     * 列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,PaymentService::getList());
    }

    /**
     * 支付方式
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function list(){
        return returnAjax("msg:ok",1,PaymentService::getTerminalList());
    }

    /**
     * 编辑
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,PaymentService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,PaymentService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 修改字段状态
     * @return \think\response\Json
     */
    public function status(){
        return returnAjax("msg:ok",1,PaymentService::status(Request::param()));
    }

    /**
     * 上传
     * @return \think\response\Json
     */
    public function upload(){
        try{
            $id    = Request::param("id",0,"intval");
            $row   = PaymentModel::where("id",$id)->find();

            if(empty($row)){
                throw new \Exception("您要查找的内容不存在",0);
            }

            $array = FileManager::upload("file",0,false,[
                "disk"      => "public",
                "original"  => false,
                "save"      => false
            ]);

            if(!empty($row["photo"])){
                // file_exists($row["photo"]) && unlink($row["photo"]);
                PaymentModel::where("id",$id)->save(["photo"=>$array["path"] ?? ""]);
            }

            return returnAjax("msg:ok",1,Image::thumb($array["path"] ?? ""));
        }catch (\Exception $ex){
            return returnAjax($ex->getMessage(),0);
        }
    }

}