<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\addons;

use app\adminapi\controller\Controller;
use app\common\library\file\File;
use app\common\library\file\FileManager;
use app\common\service\Config;
use think\facade\Request;

/**
 * @package app\adminapi\controller\addons
 * @class Miniprogram
 * @author xzncit 2024-02-22
 */
class Miniprogram extends Controller {

    public $auth = ['except'=>['upload']];

    /**
     * @return \think\response\Json
     */
    public function index(){
        if(Request::isPost()){
            Config::save("miniprogram",Request::param());
            return returnAjax("操作成功",1);
        }

        $config = Config::getArray("miniprogram",[
            "name"          => "",
            "appid"         => "",
            "appsecret"     => "",
            "qrcode"        => ""
        ],true);

        return returnAjax("msg:ok",1,$config);
    }

    /**
     * @return \think\response\Json
     */
    public function upload(){
        try{
            $array = FileManager::upload("file",0,false,[
                "disk"      => "root",
                "ext"       => "txt",
                "original"  => true,
                "save"      => false
            ]);

            $config = Config::getArray("miniprogram",[
                "name"          => "",
                "appid"         => "",
                "appsecret"     => "",
                "qrcode"        => ""
            ],true);

            if(!empty($config["file"])){
                $path = File::getPath() . 'public/' . $config["file"];
                file_exists($path) && unlink($path);
            }

            $config["file"] = $array["filename"] ?? "";
            Config::save("miniprogram",$config);
            return returnAjax("msg:ok",1,$config["file"]);
        }catch (\Exception $ex){
            return returnAjax($ex->getMessage(),0);
        }
    }

}