<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\addons;

use think\facade\Request;
use app\adminapi\controller\Controller;
use app\adminapi\service\Help as HelpService;

/**
 * @package app\adminapi\controller\addons
 * @class Help
 * @author xzncit 2024-03-05
 */
class Help extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,HelpService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,HelpService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,HelpService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,HelpService::delete(Request::param("id",0,"intval")));
    }

}