<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\addons;

use app\adminapi\controller\Controller;
use think\facade\Request;
use app\adminapi\service\Category as CategoryService;

/**
 * @package app\adminapi\controller\addons
 * @class Category
 * @author xzncit 2024-02-23
 */
class Category extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        $params           = Request::param();
        $params["module"] = "article";
        return returnAjax("msg:ok",1,CategoryService::getList($params));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            $params             = Request::param();
            $params["module"]   = "article";
            CategoryService::save($params);
            return returnAjax("msg:ok",1);
        }

        return returnAjax("msg:ok",1,CategoryService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 状态
     * @return \think\response\Json
     */
    public function status(){
        $params = Request::param();
        return returnAjax("msg:ok",1,CategoryService::status($params));
    }

    /**
     * 删除
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function delete(){
        $id = Request::param("id",0,"intval");
        return returnAjax("msg:ok",1,CategoryService::delete($id));
    }

}