<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller\addons;

use app\adminapi\controller\Controller;
use think\facade\Request;
use app\adminapi\service\Archives as ArchivesService;

/**
 * @package app\adminapi\controller\addons
 * @class Archives
 * @author xzncit 2024-02-23
 */
class Archives extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,ArchivesService::getList(Request::param()));
    }

    /**
     * 编辑
     * @return \think\response\Json
     */
    public function editor(){
        if(Request::isPost()){
            return returnAjax("msg:ok",1,ArchivesService::save(Request::param()));
        }

        return returnAjax("msg:ok",1,ArchivesService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 状态
     * @return \think\response\Json
     */
    public function status(){
        return returnAjax("msg:ok",1,ArchivesService::status(Request::param()));
    }

    /**
     * 删除
     * @return \think\response\Json
     */
    public function delete(){
        return returnAjax("msg:ok",1,ArchivesService::delete(Request::param("id",0,"intval")));
    }

}