<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\controller;

use app\Controller;
use app\adminapi\service\Purview as PurviewService;

/**
 * @package app\adminapi\controller
 * @class Purview
 * @author xzncit 2024-01-12
 */
class Purview extends Controller {

    public $auth = ['except'=>['index']];

    /**
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,[
            "sidebar"   => PurviewService::getMenu(),
            "auth"      => PurviewService::getAuth(),
            "routes"    => PurviewService::getRoutes()
        ]);
    }

}